-------------------------------------------
--- Author: Ketho (EU-Boulderfist)		---
--- License: Public Domain				---
--- Created: 2011.11.21					---
--- Version: 1.1 [2015.04.09]			---
-------------------------------------------
--- Curse			http://www.curse.com/addons/wow/autoconfirmroll
--- WoWInterface	http://www.wowinterface.com/downloads/info20516-AutoConfirmRoll.html

local remap = {
	CONFIRM_LOOT_ROLL = "CONFIRM_ROLL",
	CONFIRM_DISENCHANT_ROLL = "CONFIRM_ROLL",
	LOOT_BIND_CONFIRM = "LOOT_BIND_CONFIRM",
}

local f = CreateFrame("Frame")

function f:OnEvent(event, ...)
	self[remap[event]](self, ...)
end

for k in pairs(remap) do
	f:RegisterEvent(k)
end

f:SetScript("OnEvent", f.OnEvent)

	--------------------------
	--- Confirm Group Roll ---
	--------------------------

function f:CONFIRM_ROLL(id, lootType)
	ConfirmLootRoll(id, lootType)
	StaticPopup_Hide("CONFIRM_LOOT_ROLL")
end

	-------------------------
	--- Confirm Solo Loot ---
	-------------------------

-- need to wait at least a single OnUpdate after the LOOT_BIND_CONFIRM event
-- LOOT_BIND_CONFIRM can fire multiple times but we only have a single OnUpdate script

local checkList = {}

function f:OnUpdate(elapsed)
	for slot in pairs(checkList) do
		LootSlot(slot)
		ConfirmLootSlot(slot)
	end
	wipe(checkList)
	StaticPopup_Hide("LOOT_BIND")
	self:SetScript("OnUpdate", nil)
end

function f:LOOT_BIND_CONFIRM(slot)
	if not checkList[slot] then
		checkList[slot] = true
		StaticPopup_Hide("LOOT_BIND")
		self:SetScript("OnUpdate", self.OnUpdate)
	end
end
