local GlobalAddonName, ExRT = ...

if ExRT.is7 then return end --This module removed in 7.0

local module = ExRT.mod:New("CSpells",ExRT.L.scspells)
local ELib,L = ExRT.lib,ExRT.L
module.db.spells = {}

--Build 19802, 3:17 27.03.2015
local SpellData = [[
local module = GExRT.A.CSpells
module.db.spells["WARRIOR"] = {
	[71] = {772,1464,1680,1719,6343,12294,12328,12712,56636,76838,86101,97462,118038,157452,157461,163201,165365,167105,167188,174737,174926,176051,176289,71,78,100,107,196,197,198,199,200,201,202,227,264,266,355,469,750,1180,1715,2457,3127,3411,5011,5246,6544,6552,6673,9077,9116,12292,15590,18499,23920,29725,29838,34428,46924,46968,55694,57755,58095,58096,58097,58098,58099,58104,58355,58356,58357,58366,58367,58368,58369,58370,58372,58375,58377,58382,58384,58386,63324,63325,63327,63328,63329,64382,68164,88163,94372,94374,103826,103827,103828,103840,107570,107574,112104,114028,114029,114030,115767,115943,115946,118000,119811,123779,123829,145585,146965,146968,146969,146970,146971,146973,146974,152277,152278,156287,156321,158836,159701,159703,159708,159738,159740,159754,159759,159761,163558,174736,176318,},
	[73] = {871,1160,2565,5308,6343,6572,12975,13046,20243,23922,29144,46953,76857,84608,86535,114192,122509,152276,157449,157479,157494,157497,158298,159362,161608,161798,165393,169680,169685,71,78,100,107,196,197,198,199,200,201,202,227,264,266,355,469,750,1180,1715,2457,3127,3411,5011,5246,6544,6552,6673,9077,9116,12292,15590,18499,23920,29725,29838,34428,46924,46968,55694,57755,58095,58096,58097,58098,58099,58104,58355,58356,58357,58366,58367,58368,58369,58370,58372,58375,58377,58382,58384,58386,63324,63325,63327,63328,63329,64382,68164,88163,94372,94374,103826,103827,103828,103840,107570,107574,112104,114028,114029,114030,115767,115943,115946,118000,119811,123779,123829,145585,146965,146968,146969,146970,146971,146973,146974,152277,152278,156287,156321,158836,159701,159703,159708,159738,159740,159754,159759,159761,163558,174736,176318,},
	[72] = {1680,1719,5308,12323,12950,13046,23588,23881,46915,46917,76856,81099,85288,86110,97462,100130,118038,157452,157454,157473,165383,167188,169679,169683,174926,176051,176289,71,78,100,107,196,197,198,199,200,201,202,227,264,266,355,469,750,1180,1715,2457,3127,3411,5011,5246,6544,6552,6673,9077,9116,12292,15590,18499,23920,29725,29838,34428,46924,46968,55694,57755,58095,58096,58097,58098,58099,58104,58355,58356,58357,58366,58367,58368,58369,58370,58372,58375,58377,58382,58384,58386,63324,63325,63327,63328,63329,64382,68164,88163,94372,94374,103826,103827,103828,103840,107570,107574,112104,114028,114029,114030,115767,115943,115946,118000,119811,123779,123829,145585,146965,146968,146969,146970,146971,146973,146974,152277,152278,156287,156321,158836,159701,159703,159708,159738,159740,159754,159759,159761,163558,174736,176318,},
}
module.db.spells["PALADIN"] = {
	[70] = {879,19750,20154,20164,20925,31801,31868,31884,53376,53385,53503,53595,76672,85256,86539,121783,140333,152262,152263,157048,157482,157493,157496,165381,167187,174718,107,196,197,198,199,200,201,202,498,633,642,750,853,1022,1044,4987,6940,7328,9077,9116,10326,13819,19740,20066,20165,20217,20271,23214,24275,25780,25956,26023,32223,34767,34769,35395,54922,54923,54924,54926,54927,54928,54930,54931,54935,54936,54938,54939,54940,54943,56414,56416,56420,57947,57954,57955,57958,57979,62124,63218,63219,63220,63224,66906,66907,69820,69826,73629,73630,82242,85499,85673,85804,86172,87172,89401,93466,96231,105361,105593,105622,105809,114039,114154,114157,114158,114163,114165,115675,115738,115750,115931,115933,115934,119477,119811,122028,123830,125043,130552,136494,146955,146956,146957,146958,146959,159548,159557,159572,159573,159579,159592,162604,171929,},
	[66] = {1038,19750,20154,20925,26573,31850,31935,53592,53595,53600,76671,85043,86102,86659,105424,105805,119072,152261,152262,152263,157482,157485,157486,157488,158298,159374,161608,161800,165375,171648,107,196,197,198,199,200,201,202,498,633,642,750,853,1022,1044,4987,6940,7328,9077,9116,10326,13819,19740,20066,20165,20217,20271,23214,24275,25780,25956,26023,32223,34767,34769,35395,54922,54923,54924,54926,54927,54928,54930,54931,54935,54936,54938,54939,54940,54943,56414,56416,56420,57947,57954,57955,57958,57979,62124,63218,63219,63220,63224,66906,66907,69820,69826,73629,73630,82242,85499,85673,85804,86172,87172,89401,93466,96231,105361,105593,105622,105809,114039,114154,114157,114158,114163,114165,115675,115738,115750,115931,115933,115934,119477,119811,122028,123830,125043,130552,136494,146955,146956,146957,146958,146959,159548,159557,159572,159573,159579,159592,162604,171929,},
	[65] = {2812,19750,20473,31821,31842,31868,53376,53551,53563,53576,76669,82326,82327,85222,86103,88821,112859,148039,156910,157007,157047,157453,157455,157478,157482,165380,107,196,197,198,199,200,201,202,498,633,642,750,853,1022,1044,4987,6940,7328,9077,9116,10326,13819,19740,20066,20165,20217,20271,23214,24275,25780,25956,26023,32223,34767,34769,35395,54922,54923,54924,54926,54927,54928,54930,54931,54935,54936,54938,54939,54940,54943,56414,56416,56420,57947,57954,57955,57958,57979,62124,63218,63219,63220,63224,66906,66907,69820,69826,73629,73630,82242,85499,85673,85804,86172,87172,89401,93466,96231,105361,105593,105622,105809,114039,114154,114157,114158,114163,114165,115675,115738,115750,115931,115933,115934,119477,119811,122028,123830,125043,130552,136494,146955,146956,146957,146958,146959,159548,159557,159572,159573,159579,159592,162604,171929,},
}
module.db.spells["HUNTER"] = {
	[254] = {3045,19434,34483,35110,53209,53351,76659,155228,157707,157718,157724,157726,163485,165378,136,196,197,200,201,202,227,264,266,781,883,982,1180,1462,1494,1499,1515,1543,2641,2643,3044,5011,5116,5118,5384,6197,6991,8737,9077,13159,13809,13813,15590,19263,19386,19506,19560,19573,19577,19801,19878,19879,19880,19882,19883,19884,19885,20736,20895,34477,51753,53271,53299,56641,56829,56833,56844,56845,56847,56850,57866,57870,57902,57903,57904,63068,77769,83242,83243,83244,83245,83495,86538,93321,93322,109212,109215,109248,109259,109260,109263,109298,109304,109306,117050,117526,118675,119384,119403,119407,119410,119447,119449,119462,119464,120360,120679,121818,122492,123632,125042,126746,130392,131894,132106,138430,146657,147362,148475,157443,159459,159469,159470,162534,172106,177667,},
	[255] = {3674,19387,53301,63458,76658,77767,87935,152245,155228,157718,157748,157751,157752,164856,165396,136,196,197,200,201,202,227,264,266,781,883,982,1180,1462,1494,1499,1515,1543,2641,2643,3044,5011,5116,5118,5384,6197,6991,8737,9077,13159,13809,13813,15590,19263,19386,19506,19560,19573,19577,19801,19878,19879,19880,19882,19883,19884,19885,20736,20895,34477,51753,53271,53299,56641,56829,56833,56844,56845,56847,56850,57866,57870,57902,57903,57904,63068,77769,83242,83243,83244,83245,83495,86538,93321,93322,109212,109215,109248,109259,109260,109263,109298,109304,109306,117050,117526,118675,119384,119403,119407,119410,119447,119449,119462,119464,120360,120679,121818,122492,123632,125042,126746,130392,131894,132106,138430,146657,147362,148475,157443,159459,159469,159470,162534,172106,177667,},
	[253] = {19574,19623,34026,34954,53253,53260,53270,53351,56315,76657,77767,82692,115939,152244,152245,157705,157714,157715,157718,165389,136,196,197,200,201,202,227,264,266,781,883,982,1180,1462,1494,1499,1515,1543,2641,2643,3044,5011,5116,5118,5384,6197,6991,8737,9077,13159,13809,13813,15590,19263,19386,19506,19560,19573,19577,19801,19878,19879,19880,19882,19883,19884,19885,20736,20895,34477,51753,53271,53299,56641,56829,56833,56844,56845,56847,56850,57866,57870,57902,57903,57904,63068,77769,83242,83243,83244,83245,83495,86538,93321,93322,109212,109215,109248,109259,109260,109263,109298,109304,109306,117050,117526,118675,119384,119403,119407,119410,119447,119449,119462,119464,120360,120679,121818,122492,123632,125042,126746,130392,131894,132106,138430,146657,147362,148475,157443,159459,159469,159470,162534,172106,177667,},
}
module.db.spells["ROGUE"] = {
	[261] = {53,1943,14183,16511,31220,31223,51701,51713,51723,58423,76808,79147,79152,91023,157666,157669,157671,157704,196,198,201,264,266,408,703,921,1180,1725,1752,1766,1776,1784,1804,1833,1856,1860,1966,2094,2098,2823,2836,2983,3408,5011,5171,5277,5938,6770,8676,8679,9077,14062,14185,15590,26679,31209,31224,31230,36554,56799,56800,56801,56804,56805,56806,56807,56809,56810,56811,56812,56813,56818,56819,57934,58017,58027,58032,58033,58038,58039,63249,63252,63253,63254,63268,63269,73651,74001,76577,79008,82245,86092,89758,91299,108208,108209,108210,108211,108212,108216,113742,114014,114015,114018,121411,121733,125044,131511,137619,138106,146625,146631,146960,146961,152150,152151,152152,154904,157442,159634,159635,159636,159638,},
	[259] = {1329,1943,14117,14190,32645,51667,51723,58423,76803,79134,79140,84601,111240,121152,157513,157514,157561,157569,165390,196,198,201,264,266,408,703,921,1180,1725,1752,1766,1776,1784,1804,1833,1856,1860,1966,2094,2098,2823,2836,2983,3408,5011,5171,5277,5938,6770,8676,8679,9077,14062,14185,15590,26679,31209,31224,31230,36554,56799,56800,56801,56804,56805,56806,56807,56809,56810,56811,56812,56813,56818,56819,57934,58017,58027,58032,58033,58038,58039,63249,63252,63253,63254,63268,63269,73651,74001,76577,79008,82245,86092,89758,91299,108208,108209,108210,108211,108212,108216,113742,114014,114015,114018,121411,121733,125044,131511,137619,138106,146625,146631,146960,146961,152150,152151,152152,154904,157442,159634,159635,159636,159638,},
	[260] = {13750,13877,14161,35551,51690,61329,76806,84617,84654,157581,157605,157615,157660,196,198,201,264,266,408,703,921,1180,1725,1752,1766,1776,1784,1804,1833,1856,1860,1966,2094,2098,2823,2836,2983,3408,5011,5171,5277,5938,6770,8676,8679,9077,14062,14185,15590,26679,31209,31224,31230,36554,56799,56800,56801,56804,56805,56806,56807,56809,56810,56811,56812,56813,56818,56819,57934,58017,58027,58032,58033,58038,58039,63249,63252,63253,63254,63268,63269,73651,74001,76577,79008,82245,86092,89758,91299,108208,108209,108210,108211,108212,108216,113742,114014,114015,114018,121411,121733,125044,131511,137619,138106,146625,146631,146960,146961,152150,152151,152152,154904,157442,159634,159635,159636,159638,},
}
module.db.spells["PRIEST"] = {
	[257] = {139,527,596,2060,14914,20711,32546,34861,45243,47788,63733,64843,77485,81206,81208,81209,87336,88625,95649,95861,109175,109186,110744,120517,121135,126135,129250,152116,152117,155245,157145,157193,157206,157207,165362,17,198,227,528,585,586,589,605,1180,1706,2006,2061,2096,5009,5019,6346,8122,9484,10060,19236,21562,32375,33076,33202,33371,34433,48045,55672,55673,55675,55676,55677,55678,55684,55685,55688,55690,55691,55692,57985,57986,58009,58228,63229,63248,64129,73325,81782,87195,88684,89489,89745,107906,108920,108939,108942,108945,109142,112833,119850,119853,119864,119866,119872,119873,120581,120583,120584,120585,121536,123040,126094,126133,126152,126174,126745,145722,147072,147776,147778,159596,159598,159599,159606,159608,159624,159626,159627,159628,162532,171921,},
	[256] = {527,596,2060,14914,15487,33206,45243,47515,47517,47536,47540,52798,62618,77484,81662,81700,81749,87336,95860,109186,109964,110744,120517,121135,129250,132157,152116,152117,152118,157129,157145,157193,157197,165376,17,198,227,528,585,586,589,605,1180,1706,2006,2061,2096,5009,5019,6346,8122,9484,10060,19236,21562,32375,33076,33202,33371,34433,48045,55672,55673,55675,55676,55677,55678,55684,55685,55688,55690,55691,55692,57985,57986,58009,58228,63229,63248,64129,73325,81782,87195,88684,89489,89745,107906,108920,108939,108942,108945,109142,112833,119850,119853,119864,119866,119872,119873,120581,120583,120584,120585,121536,123040,126094,126133,126152,126174,126745,145722,147072,147776,147778,159596,159598,159599,159606,159608,159624,159626,159627,159628,162532,171921,},
	[258] = {2944,8092,15286,15407,15473,15487,32379,34914,47585,49868,64044,73510,77486,78203,95740,120644,122121,127632,139139,155246,155271,155361,157129,157217,157218,157223,162448,162452,165201,165370,17,198,227,528,585,586,589,605,1180,1706,2006,2061,2096,5009,5019,6346,8122,9484,10060,19236,21562,32375,33076,33202,33371,34433,48045,55672,55673,55675,55676,55677,55678,55684,55685,55688,55690,55691,55692,57985,57986,58009,58228,63229,63248,64129,73325,81782,87195,88684,89489,89745,107906,108920,108939,108942,108945,109142,112833,119850,119853,119864,119866,119872,119873,120581,120583,120584,120585,121536,123040,126094,126133,126152,126174,126745,145722,147072,147776,147778,159596,159598,159599,159606,159608,159624,159626,159627,159628,162532,171921,},
}
module.db.spells["DEATHKNIGHT"] = {
	[251] = {674,49020,49143,49184,50385,50887,51128,51271,54637,55610,59057,66192,77514,81333,86113,130735,157367,157376,157389,157409,196,197,198,199,200,201,202,750,3714,9077,42650,43265,45462,45477,45524,45529,47476,47528,47541,47568,48263,48265,48266,48707,48743,48778,48792,49039,49576,49998,50041,50842,50977,51052,51462,51986,53331,53342,53343,53344,53428,54447,54729,55078,55095,57330,58616,58618,58620,58623,58629,58631,58635,58640,58642,58647,58657,58669,58671,58673,58676,58677,58680,58686,59307,59309,59327,59332,59336,60200,61999,62158,62259,63330,63331,63333,63335,73313,77575,77606,81229,82246,86524,96268,108194,108196,108199,108200,108201,111673,114556,115989,119811,119975,123693,130736,146645,146648,146652,152279,152280,152281,159415,159416,159418,159421,159427,159428,159429,161497,178819,},
	[252] = {46584,49206,49530,49572,50392,51160,55090,55610,56835,63560,77515,85948,86536,91107,157342,157412,157437,157441,165395,196,197,198,199,200,201,202,750,3714,9077,42650,43265,45462,45477,45524,45529,47476,47528,47541,47568,48263,48265,48266,48707,48743,48778,48792,49039,49576,49998,50041,50842,50977,51052,51462,51986,53331,53342,53343,53344,53428,54447,54729,55078,55095,57330,58616,58618,58620,58623,58629,58631,58635,58640,58642,58647,58657,58669,58671,58673,58676,58677,58680,58686,59307,59309,59327,59332,59336,60200,61999,62158,62259,63330,63331,63333,63335,73313,77575,77606,81229,82246,86524,96268,108194,108196,108199,108200,108201,111673,114556,115989,119811,119975,123693,130736,146645,146648,146652,152279,152280,152281,159415,159416,159418,159421,159427,159428,159429,161497,178819,},
	[250] = {48982,49028,49222,49509,50029,50034,50371,55233,56222,77513,81127,81136,81164,86537,114866,155522,157336,157337,157338,157343,158298,161608,161797,165394,196,197,198,199,200,201,202,750,3714,9077,42650,43265,45462,45477,45524,45529,47476,47528,47541,47568,48263,48265,48266,48707,48743,48778,48792,49039,49576,49998,50041,50842,50977,51052,51462,51986,53331,53342,53343,53344,53428,54447,54729,55078,55095,57330,58616,58618,58620,58623,58629,58631,58635,58640,58642,58647,58657,58669,58671,58673,58676,58677,58680,58686,59307,59309,59327,59332,59336,60200,61999,62158,62259,63330,63331,63333,63335,73313,77575,77606,81229,82246,86524,96268,108194,108196,108199,108200,108201,111673,114556,115989,119811,119975,123693,130736,146645,146648,146652,152279,152280,152281,159415,159416,159418,159421,159427,159428,159429,161497,178819,},
}
module.db.spells["SHAMAN"] = {
	[264] = {974,1064,16196,16213,51505,51564,52127,55453,61295,77130,77226,77472,79206,86100,95862,98008,108280,112858,114052,157153,157154,157764,157784,157812,157813,165391,165479,107,196,197,198,199,227,324,370,403,421,546,556,1180,2008,2062,2484,2645,2825,2894,3599,5394,6196,8004,8050,8056,8143,8177,8737,9077,9116,15590,16166,16188,20608,30884,32182,36936,51485,51514,51886,55436,55437,55438,55439,55440,55441,55442,55443,55444,55445,55446,55447,55448,55449,55450,55451,55452,55454,55455,55456,57994,58057,58058,58059,58135,59289,62132,63270,63271,63273,63279,63280,63291,63298,63374,73899,73920,86529,101052,108269,108270,108271,108273,108281,108282,108283,108284,108285,108287,116956,117013,117014,147074,147707,147762,147770,147772,147781,147783,147784,147785,147787,147788,152256,159640,159642,159643,159644,159647,159648,159649,159650,159651,161654,171933,},
	[263] = {1535,8190,10400,16282,17364,30814,30823,33757,51522,51530,51533,58875,60103,73680,77223,86099,86629,114051,117012,152255,152257,157444,157764,157784,157804,157807,165368,166221,107,196,197,198,199,227,324,370,403,421,546,556,1180,2008,2062,2484,2645,2825,2894,3599,5394,6196,8004,8050,8056,8143,8177,8737,9077,9116,15590,16166,16188,20608,30884,32182,36936,51485,51514,51886,55436,55437,55438,55439,55440,55441,55442,55443,55444,55445,55446,55447,55448,55449,55450,55451,55452,55454,55455,55456,57994,58057,58058,58059,58135,59289,62132,63270,63271,63273,63279,63280,63291,63298,63374,73899,73920,86529,101052,108269,108270,108271,108273,108281,108282,108283,108284,108285,108287,116956,117013,117014,147074,147707,147762,147770,147772,147781,147783,147784,147785,147787,147788,152256,159640,159642,159643,159644,159647,159648,159649,159650,159651,161654,171933,},
	[262] = {8042,29000,30823,51490,51505,60188,61882,62099,77756,79206,86108,88766,114050,123099,152255,152257,157764,157765,157774,157784,165399,165462,165477,170374,107,196,197,198,199,227,324,370,403,421,546,556,1180,2008,2062,2484,2645,2825,2894,3599,5394,6196,8004,8050,8056,8143,8177,8737,9077,9116,15590,16166,16188,20608,30884,32182,36936,51485,51514,51886,55436,55437,55438,55439,55440,55441,55442,55443,55444,55445,55446,55447,55448,55449,55450,55451,55452,55454,55455,55456,57994,58057,58058,58059,58135,59289,62132,63270,63271,63273,63279,63280,63291,63298,63374,73899,73920,86529,101052,108269,108270,108271,108273,108281,108282,108283,108284,108285,108287,116956,117013,117014,147074,147707,147762,147770,147772,147781,147783,147784,147785,147787,147788,152256,159640,159642,159643,159644,159647,159648,159649,159650,159651,161654,171933,},
}
module.db.spells["MAGE"] = {
	[64] = {10,116,7302,12472,12982,30455,31687,44549,44572,76613,84714,112948,112965,153595,155149,157646,157721,157727,157738,157997,165360,66,118,120,122,130,201,227,475,1180,1459,1463,1953,2136,2139,3561,3562,3563,3565,3566,3567,5009,5019,10059,11416,11417,11418,11419,11420,11426,11958,28271,28272,30449,32266,32267,32271,32272,33690,33691,35715,35717,42955,43987,44614,45438,49358,49359,49360,49361,53140,53142,55342,56364,56365,56368,56375,56376,56377,56382,56384,57925,61205,61305,61316,61721,61780,62210,63090,63092,80353,86209,86949,88342,88344,88345,88346,89744,89749,89926,102051,108839,108843,108978,110959,111264,113724,115700,115703,115705,115710,115713,115718,115723,116011,117957,120145,120146,126748,126819,132620,132621,132626,132627,140468,146659,146662,146976,147353,152087,157913,157976,159485,159486,159916,161353,161354,161355,161372,176242,176244,176246,176248,},
	[63] = {133,2120,2948,11129,11366,12846,30482,31661,44457,108853,117216,153561,155148,157621,157629,157632,157642,157981,165357,66,118,120,122,130,201,227,475,1180,1459,1463,1953,2136,2139,3561,3562,3563,3565,3566,3567,5009,5019,10059,11416,11417,11418,11419,11420,11426,11958,28271,28272,30449,32266,32267,32271,32272,33690,33691,35715,35717,42955,43987,44614,45438,49358,49359,49360,49361,53140,53142,55342,56364,56365,56368,56375,56376,56377,56382,56384,57925,61205,61305,61316,61721,61780,62210,63090,63092,80353,86209,86949,88342,88344,88345,88346,89744,89749,89926,102051,108839,108843,108978,110959,111264,113724,115700,115703,115705,115710,115713,115718,115723,116011,117957,120145,120146,126748,126819,132620,132621,132626,132627,140468,146659,146662,146976,147353,152087,157913,157976,159485,159486,159916,161353,161354,161355,161372,176242,176244,176246,176248,},
	[62] = {1449,5143,6117,12042,12043,12051,30451,31589,44425,76547,114664,114923,153626,155147,157595,157604,157606,157614,157980,165359,66,118,120,122,130,201,227,475,1180,1459,1463,1953,2136,2139,3561,3562,3563,3565,3566,3567,5009,5019,10059,11416,11417,11418,11419,11420,11426,11958,28271,28272,30449,32266,32267,32271,32272,33690,33691,35715,35717,42955,43987,44614,45438,49358,49359,49360,49361,53140,53142,55342,56364,56365,56368,56375,56376,56377,56382,56384,57925,61205,61305,61316,61721,61780,62210,63090,63092,80353,86209,86949,88342,88344,88345,88346,89744,89749,89926,102051,108839,108843,108978,110959,111264,113724,115700,115703,115705,115710,115713,115718,115723,116011,117957,120145,120146,126748,126819,132620,132621,132626,132627,140468,146659,146662,146976,147353,152087,157913,157976,159485,159486,159916,161353,161354,161355,161372,176242,176244,176246,176248,},
}
module.db.spells["WARLOCK"] = {
	[267] = {348,5740,17877,17962,29722,77220,80240,108503,108647,108683,109784,111546,113858,114635,116858,117896,120451,157103,157114,157121,157126,157696,165363,174848,126,172,201,227,686,688,691,697,698,710,712,1098,1122,1180,5009,5019,5484,5697,5782,5784,6201,6789,18540,20707,23161,29858,29893,30283,48018,48020,56217,56218,56224,56226,56231,56232,56233,56235,56238,56240,56241,56242,56244,56246,56247,56248,56249,58070,58079,58081,58094,58107,63302,63304,63309,63312,63320,86091,93375,101976,104773,108359,108370,108415,108416,108482,108499,108501,108505,108508,109773,110913,111397,111400,111771,119898,135557,137587,146962,146964,148683,152107,152108,159665,159669,159680,159688,159691,159693,159697,166928,},
	[265] = {689,755,980,1454,27243,30108,48181,74434,77215,86121,103103,108371,108503,108558,113860,117198,152109,157069,157072,157077,157078,165367,126,172,201,227,686,688,691,697,698,710,712,1098,1122,1180,5009,5019,5484,5697,5782,5784,6201,6789,18540,20707,23161,29858,29893,30283,48018,48020,56217,56218,56224,56226,56231,56232,56233,56235,56238,56240,56241,56242,56244,56246,56247,56248,56249,58070,58079,58081,58094,58107,63302,63304,63309,63312,63320,86091,93375,101976,104773,108359,108370,108415,108416,108482,108499,108501,108505,108508,109773,110913,111397,111400,111771,119898,135557,137587,146962,146964,148683,152107,152108,159665,159669,159680,159688,159691,159693,159697,166928,},
	[266] = {689,755,1454,1949,6353,30146,77219,103958,104315,105174,108371,108869,109151,113861,114592,122351,124913,157069,157096,157098,157100,157695,165392,171975,126,172,201,227,686,688,691,697,698,710,712,1098,1122,1180,5009,5019,5484,5697,5782,5784,6201,6789,18540,20707,23161,29858,29893,30283,48018,48020,56217,56218,56224,56226,56231,56232,56233,56235,56238,56240,56241,56242,56244,56246,56247,56248,56249,58070,58079,58081,58094,58107,63302,63304,63309,63312,63320,86091,93375,101976,104773,108359,108370,108415,108416,108482,108499,108501,108505,108508,109773,110913,111397,111400,111771,119898,135557,137587,146962,146964,148683,152107,152108,159665,159669,159680,159688,159691,159693,159697,166928,},
}
module.db.spells["MONK"] = {
	[269] = {101545,107428,113656,115176,115288,115636,116092,116095,116740,116781,120227,122470,123980,124146,128595,137384,137639,152173,152174,152175,157361,157366,157411,157415,157445,165398,166916,196,198,200,201,227,9077,15590,100780,100784,100787,101546,101643,103985,109132,115008,115072,115074,115078,115080,115098,115173,115174,115178,115203,115396,115399,115450,115546,116694,116705,116812,116841,116844,116847,117952,119381,119392,119996,120272,120277,120477,120483,121817,122278,122280,122783,123023,123334,123391,123394,123401,123403,123763,123904,123986,124081,124989,124997,125151,125154,125660,125671,125678,125732,125755,125872,125893,125901,125931,125967,126892,126895,132005,137562,146950,146951,146952,146953,146954,159487,159490,159492,159495,159496,159497,159534,159536,159545,171926,173182,},
	[270] = {107428,115070,115151,115175,115294,115310,115313,115451,115460,115921,116645,116670,116680,116849,117907,120224,121278,123766,124682,139598,154436,154555,157361,157366,157398,157401,157535,157675,165397,173841,196,198,200,201,227,9077,15590,100780,100784,100787,101546,101643,103985,109132,115008,115072,115074,115078,115080,115098,115173,115174,115178,115203,115396,115399,115450,115546,116694,116705,116812,116841,116844,116847,117952,119381,119392,119996,120272,120277,120477,120483,121817,122278,122280,122783,123023,123334,123391,123394,123401,123403,123763,123904,123986,124081,124989,124997,125151,125154,125660,125671,125678,125732,125755,125872,125893,125901,125931,125967,126892,126895,132005,137562,146950,146951,146952,146953,146954,159487,159490,159492,159495,159496,159497,159534,159536,159545,171926,173182,},
	[268] = {115069,115176,115180,115181,115295,115308,115315,116781,117906,117967,119582,120225,121253,124146,124502,126060,128938,152173,157361,157362,157363,157366,157445,157533,157676,158298,161608,165379,196,198,200,201,227,9077,15590,100780,100784,100787,101546,101643,103985,109132,115008,115072,115074,115078,115080,115098,115173,115174,115178,115203,115396,115399,115450,115546,116694,116705,116812,116841,116844,116847,117952,119381,119392,119996,120272,120277,120477,120483,121817,122278,122280,122783,123023,123334,123391,123394,123401,123403,123763,123904,123986,124081,124989,124997,125151,125154,125660,125671,125678,125732,125755,125872,125893,125901,125931,125967,126892,126895,132005,137562,146950,146951,146952,146953,146954,159487,159490,159492,159495,159496,159497,159534,159536,159545,171926,173182,},
}
module.db.spells["DRUID"] = {
	[105] = {740,8936,17073,18562,22812,33763,33891,48438,48500,77495,85101,86093,88423,92364,102342,102693,108294,108299,112857,113043,132158,145205,145518,155577,155675,155834,157300,157301,157305,157312,158478,158504,165374,99,198,199,200,227,339,768,774,783,1126,1180,1850,2908,5176,5185,5211,5215,5221,5225,5487,6795,8921,9077,15590,16870,16961,17076,18960,20484,22568,22842,33786,33917,47180,48514,50769,54733,54760,54811,54812,54821,54825,54831,57855,57856,59219,62970,63057,67598,77758,94386,102280,102351,102359,102401,102793,106830,106832,106898,107059,108238,114222,114223,114237,114280,114295,114301,114333,114338,116172,116216,116218,121840,124974,125047,125972,127540,131113,131768,132469,145108,146654,146655,146656,159432,159434,159436,159444,159445,159450,159453,159455,159456,164812,164815,164997,165962,171752,171803,171924,},
	[103] = {770,1079,1822,2782,5217,16864,16974,17007,22570,33873,48484,52610,61336,77493,86097,102543,102703,106707,106785,106839,106952,108292,155580,155672,157269,157274,157276,157280,157447,158476,158497,165372,166142,171746,99,198,199,200,227,339,768,774,783,1126,1180,1850,2908,5176,5185,5211,5215,5221,5225,5487,6795,8921,9077,15590,16870,16961,17076,18960,20484,22568,22842,33786,33917,47180,48514,50769,54733,54760,54811,54812,54821,54825,54831,57855,57856,59219,62970,63057,67598,77758,94386,102280,102351,102359,102401,102793,106830,106832,106898,107059,108238,114222,114223,114237,114280,114295,114301,114333,114338,116172,116216,116218,121840,124974,125047,125972,127540,131113,131768,132469,145108,146654,146655,146656,159432,159434,159436,159444,159445,159450,159453,159455,159456,164812,164815,164997,165962,171752,171803,171924,},
	[104] = {770,2782,6807,16931,22812,33745,33873,48484,61336,62606,80313,86096,102558,102706,106707,106839,106952,108293,135288,155578,155783,155835,157283,157284,157286,157292,157447,158298,158477,158501,159232,161608,165387,166142,99,198,199,200,227,339,768,774,783,1126,1180,1850,2908,5176,5185,5211,5215,5221,5225,5487,6795,8921,9077,15590,16870,16961,17076,18960,20484,22568,22842,33786,33917,47180,48514,50769,54733,54760,54811,54812,54821,54825,54831,57855,57856,59219,62970,63057,67598,77758,94386,102280,102351,102359,102401,102793,106830,106832,106898,107059,108238,114222,114223,114237,114280,114295,114301,114333,114338,116172,116216,116218,121840,124974,125047,125972,127540,131113,131768,132469,145108,146654,146655,146656,159432,159434,159436,159444,159445,159450,159453,159455,159456,164812,164815,164997,165962,171752,171803,171924,},
	[102] = {2782,2912,22812,24858,33605,33831,48505,77492,78674,78675,86104,88747,93399,102560,108291,108299,108373,112071,112857,114107,127663,152220,152221,152222,157227,157229,157232,157301,165386,166163,179333,99,198,199,200,227,339,768,774,783,1126,1180,1850,2908,5176,5185,5211,5215,5221,5225,5487,6795,8921,9077,15590,16870,16961,17076,18960,20484,22568,22842,33786,33917,47180,48514,50769,54733,54760,54811,54812,54821,54825,54831,57855,57856,59219,62970,63057,67598,77758,94386,102280,102351,102359,102401,102793,106830,106832,106898,107059,108238,114222,114223,114237,114280,114295,114301,114333,114338,116172,116216,116218,121840,124974,125047,125972,127540,131113,131768,132469,145108,146654,146655,146656,159432,159434,159436,159444,159445,159450,159453,159455,159456,164812,164815,164997,165962,171752,171803,171924,},
}
module.db.spells["PET"] = {
	[0] = {2649,3110,3716,6358,6360,7814,7870,16827,17253,17735,17767,19505,19647,24423,24450,24604,24844,25027,26064,30151,30153,30213,31707,32233,33395,34889,35290,35346,36213,47468,47481,47482,47484,49966,50256,50433,50518,50519,54049,54644,54680,57386,57984,58604,62137,65220,85692,88680,89751,89766,89792,89808,90309,90328,90339,90347,90355,90361,90363,90364,91776,91778,91797,91800,91802,91809,91837,91838,92380,93433,93435,94019,94022,112042,114355,115232,115236,115268,115276,115284,115408,115578,115625,115746,115748,115770,115778,115781,115831,117225,117588,118297,118337,118345,118347,118350,119899,123746,126259,126309,126311,126364,126373,126393,128432,128433,128997,134477,135029,135678,137798,157331,157348,157375,157382,159733,159735,159788,159926,159931,159953,159956,159988,160003,160007,160011,160014,160017,160039,160044,160045,160049,160052,160057,160060,160063,160065,160067,160073,160074,160077,170176,170995,170996,171011,171012,171014,171017,171018,171021,171023,171138,173035,},
}
]]

module.db.classNames = {"WARRIOR","PALADIN","HUNTER","ROGUE","PRIEST","DEATHKNIGHT","SHAMAN","MAGE","WARLOCK","MONK","DRUID","PET"}

module.db.specByClass = {
	["HUNTER"] = {253,254,255,},
	["WARRIOR"] = {71,72,73,},
	["PALADIN"] = {65,66,70,},
	["MAGE"] = {62,63,64,},
	["PRIEST"] = {256,257,258,},
	["MONK"] = {268,269,270,},
	["WARLOCK"] = {265,266,267,},
	["SHAMAN"] = {262,263,264,},
	["ROGUE"] = {259,260,261,},
	["DRUID"] = {102,103,104,105,},
	["DEATHKNIGHT"] = {250,251,252,},
}

module.db.specInLocalizate = {
	[62] = "MAGEDPS1",
	[63] = "MAGEDPS2",
	[64] = "MAGEDPS3",
	[65] = "PALADINHEAL",
	[66] = "PALADINTANK",
	[70] = "PALADINDPS",
	[71] = "WARRIORDPS1",
	[72] = "WARRIORDPS2",
	[73] = "WARRIORTANK",
	[102] = "DRUIDDPS1",
	[103] = "DRUIDDPS2",
	[104] = "DRUIDTANK",
	[105] = "DRUIDHEAL",
	[250] = "DEATHKNIGHTTANK",
	[251] = "DEATHKNIGHTDPS1",
	[252] = "DEATHKNIGHTDPS2",
	[253] = "HUNTERDPS1",
	[254] = "HUNTERDPS2",
	[255] = "HUNTERDPS3",
	[256] = "PRIESTHEAL1",
	[257] = "PRIESTHEAL2",
	[258] = "PRIESTDPS",
	[259] = "ROGUEDPS1",
	[260] = "ROGUEDPS2",
	[261] = "ROGUEDPS3",
	[262] = "SHAMANDPS1",
	[263] = "SHAMANDPS2",
	[264] = "SHAMANHEAL",
	[265] = "WARLOCKDPS1",
	[266] = "WARLOCKDPS2",
	[267] = "WARLOCKDPS3",
	[268] = "MONKTANK",
	[269] = "MONKDPS",
	[270] = "MONKHEAL",
	[0] = "NO",
}
module.db.specIcons = {
	[62] = "Interface\\Icons\\Spell_Holy_MagicalSentry",
	[63] = "Interface\\Icons\\Spell_Fire_FireBolt02",
	[64] = "Interface\\Icons\\Spell_Frost_FrostBolt02",
	[65] = "Interface\\Icons\\Spell_Holy_HolyBolt",
	[66] = "Interface\\Icons\\Ability_Paladin_ShieldoftheTemplar",
	[70] = "Interface\\Icons\\Spell_Holy_AuraOfLight",
	[71] = "Interface\\Icons\\Ability_Warrior_SavageBlow",
	[72] = "Interface\\Icons\\Ability_Warrior_InnerRage",
	[73] = "Interface\\Icons\\Ability_Warrior_DefensiveStance",
	[102] = "Interface\\Icons\\Spell_Nature_StarFall",
	[103] = "Interface\\Icons\\Ability_Druid_CatForm",
	[104] = "Interface\\Icons\\Ability_Racial_BearForm",
	[105] = "Interface\\Icons\\Spell_Nature_HealingTouch",
	[250] = "Interface\\Icons\\Spell_Deathknight_BloodPresence",
	[251] = "Interface\\Icons\\Spell_Deathknight_FrostPresence",
	[252] = "Interface\\Icons\\Spell_Deathknight_UnholyPresence",
	[253] = "INTERFACE\\ICONS\\ability_hunter_bestialdiscipline",
	[254] = "Interface\\Icons\\Ability_Hunter_FocusedAim",
	[255] = "INTERFACE\\ICONS\\ability_hunter_camouflage",
	[256] = "Interface\\Icons\\Spell_Holy_PowerWordShield",
	[257] = "Interface\\Icons\\Spell_Holy_GuardianSpirit",
	[258] = "Interface\\Icons\\Spell_Shadow_ShadowWordPain",
	[259] = "Interface\\Icons\\Ability_Rogue_Eviscerate",
	[260] = "Interface\\Icons\\Ability_BackStab",
	[261] = "Interface\\Icons\\Ability_Stealth",
	[262] = "Interface\\Icons\\Spell_Nature_Lightning",
	[263] = "Interface\\Icons\\Spell_Shaman_ImprovedStormstrike",
	[264] = "Interface\\Icons\\Spell_Nature_MagicImmunity",
	[265] = "Interface\\Icons\\Spell_Shadow_DeathCoil",
	[266] = "Interface\\Icons\\Spell_Shadow_Metamorphosis",
	[267] = "Interface\\Icons\\Spell_Shadow_RainOfFire",
	[268] = "Interface\\Icons\\spell_monk_brewmaster_spec",
	[269] = "Interface\\Icons\\spell_monk_windwalker_spec",
	[270] = "Interface\\Icons\\spell_monk_mistweaver_spec",
}

function module.options:Load()
	self:CreateTilte()

	loadstring(SpellData)()
	SpellData = nil
	
	local ReloadPage = nil
	local classNow = "PALADIN"
	local specNow = 1
	local scrollFrameValue = 0
	local scrollFix = false
		
	self.scrollFrame = ELib:ScrollFrame(self):Size(655,550):Point("TOP",0,-60):Height(1070)
	
	local spellLineHeight = 26
	local spellLineWidth = 211
	self.scrollFrame.C.spells = {}
	local function SpellLineClick(self)
		ExRT.F.LinkSpell(self.spellID)
	end
	local function SpellLineEnter(self)
		ELib.Tooltip.Link(self,self.link) 
	end
	local function SpellLineLeave(self)
		ELib.Tooltip:Hide() 
	end
	for i=1,3 do
		for j=1,23 do
			local frame = CreateFrame("Button",nil,self.scrollFrame.C)
			self.scrollFrame.C.spells[(j-1)*3+i] = frame
			frame:SetSize(spellLineWidth,spellLineHeight)
			frame:SetPoint("TOPLEFT", (i-1)*spellLineWidth, -(j-1)*spellLineHeight)
			frame.icon = frame:CreateTexture(nil, "BACKGROUND")
			frame.icon:SetTexture("Interface\\Icons\\INV_MISC_QUESTIONMARK")
			frame.icon:SetPoint("TOPLEFT", 0, 0)
			frame.icon:SetSize(spellLineHeight-1,spellLineHeight-1)
		
			frame.spellID = 0
	
			frame:RegisterForClicks("LeftButtonDown")
			frame:SetScript("OnClick", SpellLineClick)
	
			frame.spellName = ELib:Text(frame,(j-1)*3+i,10):Size(spellLineWidth-spellLineHeight-5,spellLineHeight):Point(spellLineHeight+5, 0):Color()
		
			frame:SetScript("OnEnter", SpellLineEnter)
			frame:SetScript("OnLeave", SpellLineLeave)
		end
	end
	self.scrollFrame.ScrollBar:SetScript("OnValueChanged", function(self,value)
		if scrollFix then
			return
		end
		local parent = self:GetParent():GetParent()
		value = ExRT.F.Round(value)
		parent:SetVerticalScroll(value % spellLineHeight) 
		self:UpdateButtons()
		local nowVal = floor(value / spellLineHeight)
		if nowVal ~= scrollFrameValue then
			scrollFrameValue = nowVal
			ReloadPage()
		end
	end)
	function ReloadPage()
		local start = scrollFrameValue * 3
		local specID = module.db.specByClass[classNow] and module.db.specByClass[classNow][specNow] or 0
		for i=1,69 do
			local spellID = module.db.spells[classNow][specID][start + i]
			if not spellID then
				module.options.scrollFrame.C.spells[i]:Hide()
			else
				local frame = module.options.scrollFrame.C.spells[i]
				local spellName,_,spellTexture = GetSpellInfo(spellID)
				frame.icon:SetTexture(spellTexture)
				--frame.link = GetSpellLink(spellID)
				frame.link = "spell:"..spellID
				frame.spellID = spellID
				frame.spellName:SetText(spellName)
				local isUnique = true
				for otherSpecID,otherSpecData in pairs(module.db.spells[classNow]) do
					if otherSpecID ~= specID then
						if ExRT.F.table_find(otherSpecData,spellID) then
							isUnique = false
						end
					end
				end
				if isUnique and specID ~= 0 then
					frame.spellName:SetTextColor(0.6,1,0.6,1)
				else
					frame.spellName:SetTextColor(1,1,1,1)
				end
				frame:Show()
			end
		end
	end
	
	local isSotred = {}
	local function sortSpells()
		for specID,specData in pairs(module.db.spells[classNow]) do
			local tmp = {}
			for _,spellID in pairs(specData) do
				local spellName = GetSpellInfo(spellID)
				if spellName then
					tmp[#tmp+1] = {spellID,spellName}
				else
					ExRT.F.dprint('Spell '..spellID..' not found')
				end
			end
			table.sort(tmp,function(a,b) if(a[2]~=b[2]) then return a[2] < b[2] else return a[1] < b[1] end end)
			table.wipe(module.db.spells[classNow][specID])
			for i=1,#tmp do
				module.db.spells[classNow][specID][i]=tmp[i][1]
			end
		end
		isSotred[classNow] = true
	end
	
	local function specButtonClick(self)
		specNow = self._i
		
		local specID = module.db.specByClass[classNow] and module.db.specByClass[classNow][self._i] or 0
		
		module.options.scrollFrame.ScrollBar:SetMinMaxValues(0,max((ceil(#module.db.spells[classNow][specID] / 3) - 21) * spellLineHeight,0))
		scrollFix = true
		module.options.scrollFrame.ScrollBar:SetValue(0)
		scrollFix = false
		scrollFrameValue = 0
		
		ReloadPage()
	end
	
	self.TMP_tab = ELib:Tabs(self,0,"1","2","3","4"):Size(500,100):Point(0,0)
	self.TMP_tab:SetBackdrop({})
	
	self.decorationLine = CreateFrame("Frame",nil,self)
	self.decorationLine.texture = self.decorationLine:CreateTexture(nil, "BACKGROUND")
	self.decorationLine:SetPoint("TOPLEFT",self,-6,-30)
	self.decorationLine:SetPoint("BOTTOMRIGHT",self,"TOPRIGHT",8,-50)
	self.decorationLine.texture:SetAllPoints()
	self.decorationLine.texture:SetTexture(1,1,1,1)
	self.decorationLine.texture:SetGradientAlpha("VERTICAL",.24,.25,.30,1,.27,.28,.33,1)
	
	self.specsButtons = {}
	for i=1,4 do
		local frame = self.TMP_tab.tabs[i].button
		self.specsButtons[i] = frame
		frame:SetText(i)
		frame:ClearAllPoints()
		if i == 1 then
			frame:SetPoint("TOPLEFT",self.decorationLine,"TOPLEFT",15,4)
		else
			frame:SetPoint("LEFT", self.specsButtons[i-1], "RIGHT", 0, 0)
		end
		frame._i = i
		frame.additionalFunc = specButtonClick
	end
	
	self.dropDown = ELib:DropDown(self,205,#module.db.classNames):Point("RIGHT",self.decorationLine,-15,0):Size(220)
	self.dropDown:SetHeight(18)

	function self.dropDown:SetValue(newValue)
		classNow = module.db.classNames[newValue]
		module.options.dropDown:SetText("|c"..ExRT.F.classColor(classNow)..L.classLocalizate[classNow])
		ELib:DropDownClose()
		
		if not isSotred[classNow] then
			sortSpells()
		end
		
		local specs = module.db.specByClass[classNow] or {}
		for i=1,4 do
			if specs[i] then
				local frame = module.options.specsButtons[i]
				frame:Show()
				frame:SetText(L.specLocalizate[ module.db.specInLocalizate[ specs[i] ] ])		
				frame:SetIcon(module.db.specIcons[ specs[i] ])
			else
				module.options.specsButtons[i]:Hide()
			end
			if i == 1 then
				module.options.specsButtons[i]:Select()
			else
				module.options.specsButtons[i]:Deselect()
			end
		end
		specNow = 1
		local specID = specs[1] or 0
		module.options.scrollFrame.ScrollBar:SetMinMaxValues(0,max((ceil(#module.db.spells[classNow][specID] / 3) - 21) * spellLineHeight,0))
		scrollFix = true
		module.options.scrollFrame.ScrollBar:SetValue(0)
		scrollFix = false
		scrollFrameValue = 0
		
		ReloadPage()
	end
	for i=1,#module.db.classNames do
		local class = module.db.classNames[i]
		self.dropDown.List[i] = {text = "|c"..ExRT.F.classColor(class)..L.classLocalizate[class],justifyH = "CENTER",arg1 = i,func = self.dropDown.SetValue}
	end
	
	self.dropDown:SetValue(math.random(1,11))
	
	self.decorationLine:SetScript("OnShow",function (self)
		for i=1,4 do
			if module.options.specsButtons[i]:IsVisible() then
				module.options.TMP_tab.resizeFunc(module.options.specsButtons[i], 0, nil, nil, module.options.specsButtons[i]:GetFontString():GetStringWidth(), module.options.specsButtons[i]:GetFontString():GetStringWidth())
			end
		end
	end)
end

function module.main:ADDON_LOADED()
end